/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmallRocketEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.HelicopterEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.CameraTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.vvp.vvp.config.server.VehicleConfigVVP;
import tech.vvp.vvp.entity.projectile.LmurEntity;
import tech.vvp.vvp.entity.vehicle.weapon.LmurWeapon;
import tech.vvp.vvp.entity.vehicle.weapon.S130Weapon;
import tech.vvp.vvp.init.ModEntities;

public class Mi28Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
HelicopterEntity,
WeaponVehicleEntity,
OBBEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Float> PROPELLER_ROT = SynchedEntityData.m_135353_(Mi28Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> LOADED_ROCKET = SynchedEntityData.m_135353_(Mi28Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_MISSILE = SynchedEntityData.m_135353_(Mi28Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public boolean engineStart;
    public boolean engineStartOver;
    public double velocity;
    public int fireIndex;
    public int holdTick;
    public int holdPowerTick;
    public float destroyRot;
    public int reloadCoolDownMissile;
    public String lockingTargetO = "none";
    public String lockingTarget = "none";
    public int lockTime;
    public boolean locked;
    public float delta_x;
    public float delta_y;
    public OBB obb = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.5781f, 1.2813f, 2.4375f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.9938f, 1.0625f, 1.3125f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb3 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.5469f, 0.625f, 2.8438f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb4 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.5469f, 1.2188f, 0.875f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb6 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.5469f, 0.7188f, 2.125f), new Quaternionf(), OBB.Part.ENGINE1);
    public OBB obb7 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.5469f, 0.7188f, 2.125f), new Quaternionf(), OBB.Part.ENGINE2);

    public Mi28Entity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<Mi28Entity>)((EntityType)ModEntities.MI_28.get()), world);
    }

    public Mi28Entity(EntityType<Mi28Entity> type, Level world) {
        super(type, world);
    }

    public static Mi28Entity clientSpawn(PlayMessages.SpawnEntity packet, Level world) {
        EntityType entityTypeFromPacket = (EntityType)BuiltInRegistries.f_256780_.m_7942_(packet.getTypeId());
        if (entityTypeFromPacket == null) {
            Mod.LOGGER.error("Failed to create entity from packet: Unknown entity type id: " + packet.getTypeId());
            return null;
        }
        if (!(entityTypeFromPacket instanceof EntityType)) {
            Mod.LOGGER.error("Retrieved EntityType is not an instance of EntityType<?> for id: " + packet.getTypeId());
            return null;
        }
        EntityType castedEntityType = entityTypeFromPacket;
        Mi28Entity entity = new Mi28Entity((EntityType<Mi28Entity>)castedEntityType, world);
        return entity;
    }

    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new LmurWeapon().sound((SoundEvent)ModSounds.INTO_MISSILE.get()), new S130Weapon().damage(((Integer)VehicleConfigVVP.MI_28_MEDIUM_ROCKET_DAMAGE.get()).floatValue()).explosionDamage(((Integer)VehicleConfigVVP.MI_28_MEDIUM_ROCKET_EXPLOSION_DAMAGE.get()).floatValue()).explosionRadius(((Integer)VehicleConfigVVP.MI_28_MEDIUM_ROCKET_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)ModSounds.INTO_MISSILE.get()).sound1p((SoundEvent)ModSounds.SMALL_ROCKET_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.SMALL_ROCKET_FIRE_3P.get())}};
    }

    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(7.0, 1.0, -2.7);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOADED_ROCKET, (Object)0);
        this.f_19804_.m_135372_(PROPELLER_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LOADED_MISSILE, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("LoadedRocket", ((Integer)this.f_19804_.m_135370_(LOADED_ROCKET)).intValue());
        compound.m_128350_("PropellerRot", ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
        compound.m_128405_("LoadedMissile", ((Integer)this.f_19804_.m_135370_(LOADED_MISSILE)).intValue());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(LOADED_ROCKET, (Object)compound.m_128451_("LoadedRocket"));
        this.f_19804_.m_135381_(PROPELLER_ROT, (Object)Float.valueOf(compound.m_128457_("PropellerRot")));
        this.f_19804_.m_135381_(LOADED_MISSILE, (Object)compound.m_128451_("LoadedMissile"));
    }

    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> {
            Entity entity = source.m_7640_();
            if (entity != null && entity.m_6095_().m_204039_(ModTags.EntityTypes.AERIAL_BOMB)) {
                damage = Float.valueOf(damage.floatValue() * 2.0f);
            }
            damage = Float.valueOf(damage.floatValue() * (this.getHealth() > 0.1f ? 0.7f : 0.05f));
            return damage;
        });
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() == ModItems.SMALL_ROCKET.get() && (Integer)this.f_19804_.m_135370_(LOADED_ROCKET) < 10) {
            this.f_19804_.m_135381_(LOADED_ROCKET, (Object)((Integer)this.f_19804_.m_135370_(LOADED_ROCKET) + 1));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.MISSILE_RELOAD.get(), this.m_5720_(), 2.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (stack.m_41720_() == ModItems.AGM.get() && (Integer)this.f_19804_.m_135370_(LOADED_MISSILE) < 4) {
            this.f_19804_.m_135381_(LOADED_MISSILE, (Object)((Integer)this.f_19804_.m_135370_(LOADED_MISSILE) + 1));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.MISSILE_RELOAD.get(), this.m_5720_(), 2.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6096_(player, hand);
    }

    public void m_6075_() {
        super.m_6075_();
        this.lockingTargetO = this.getTargetUuid();
        this.updateOBB();
        if (this.m_9236_() instanceof ServerLevel) {
            if (this.reloadCoolDown > 0) {
                --this.reloadCoolDown;
            }
            if (this.reloadCoolDownMissile > 0) {
                --this.reloadCoolDownMissile;
            }
            this.handleAmmo();
        }
        this.releaseDecoy();
        this.lowHealthWarning();
        this.terrainCompact(2.7f, 2.7f);
        this.m_6210_();
    }

    private void handleAmmo() {
        Player player;
        Entity entity = this.m_146895_();
        boolean hasCreativeAmmoBox = entity instanceof Player && InventoryTool.hasCreativeAmmoBox((Entity)(player = (Player)entity));
        int ammoCount = this.m_18947_((Item)ModItems.SMALL_SHELL.get());
        if ((this.hasItem((Item)ModItems.SMALL_ROCKET.get()) || hasCreativeAmmoBox) && this.reloadCoolDown == 0 && (Integer)this.m_20088_().m_135370_(LOADED_ROCKET) < 10) {
            this.f_19804_.m_135381_(LOADED_ROCKET, (Object)((Integer)this.m_20088_().m_135370_(LOADED_ROCKET) + 1));
            this.reloadCoolDown = 100;
            if (!hasCreativeAmmoBox) {
                this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.SMALL_ROCKET.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.MISSILE_RELOAD.get(), this.m_5720_(), 2.0f, 1.0f);
        }
        if ((this.hasItem((Item)ModItems.AGM.get()) || hasCreativeAmmoBox) && this.reloadCoolDownMissile == 0 && (Integer)this.m_20088_().m_135370_(LOADED_MISSILE) < 4) {
            this.f_19804_.m_135381_(LOADED_MISSILE, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE) + 1));
            this.reloadCoolDownMissile = 160;
            if (!hasCreativeAmmoBox) {
                this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.AGM.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.BOMB_RELOAD.get(), this.m_5720_(), 2.0f, 1.0f);
        }
        if (this.getWeaponIndex(0) == 0) {
            this.f_19804_.m_135381_(AMMO, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE)));
        } else if (this.getWeaponIndex(0) == 1) {
            this.f_19804_.m_135381_(AMMO, (Object)((Integer)this.m_20088_().m_135370_(LOADED_ROCKET)));
        }
    }

    public void seekTarget() {
        ServerPlayer serverPlayer;
        Entity entity = this.m_146895_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.getTargetUuid().equals(this.lockingTargetO) && !this.getTargetUuid().equals("none")) {
            ++this.lockTime;
        } else {
            this.resetSeek(player);
        }
        Entity entity2 = SeekTool.seekCustomSizeEntity((Entity)this, (Level)this.m_9236_(), (double)384.0, (double)18.0, (double)0.9, (boolean)true);
        if (entity2 != null) {
            if (this.lockTime == 0) {
                this.setTargetUuid(String.valueOf(entity2.m_20148_()));
            }
            if (!String.valueOf(entity2.m_20148_()).equals(this.getTargetUuid())) {
                this.resetSeek(player);
                this.setTargetUuid(String.valueOf(entity2.m_20148_()));
            }
        } else {
            this.setTargetUuid("none");
        }
        if (this.lockTime == 1 && player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound((ServerPlayer)serverPlayer, (SoundEvent)((SoundEvent)ModSounds.JET_LOCK.get()), (float)2.0f, (float)1.0f);
        }
        if (this.lockTime > 10) {
            if (player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                SoundTool.playLocalSound((ServerPlayer)serverPlayer, (SoundEvent)((SoundEvent)ModSounds.JET_LOCKON.get()), (float)2.0f, (float)1.0f);
            }
            this.locked = true;
        }
    }

    public void resetSeek(Player player) {
        this.lockTime = 0;
        this.locked = false;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(new ResourceLocation("superbwarfare", "jet_lock"), SoundSource.PLAYERS);
            serverPlayer.f_8906_.m_9829_((Packet)clientboundstopsoundpacket);
        }
    }

    public void setTargetUuid(String uuid) {
        this.lockingTarget = uuid;
    }

    public String getTargetUuid() {
        return this.lockingTarget;
    }

    public void travel() {
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.8, 1.0, 0.8));
        } else {
            this.setZRot(this.getRoll() * (this.backInputDown ? 0.9f : 0.99f));
            float f = (float)Mth.m_14008_((double)((double)0.95f - 0.015 * this.m_20184_().m_82553_() + (double)(0.02f * Mth.m_14154_((float)(90.0f - (float)Mi28Entity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f)), (double)0.01, (double)0.99);
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82490_((this.m_146909_() < 0.0f ? -0.035 : (this.m_146909_() > 0.0f ? 0.035 : 0.0)) * this.m_20184_().m_82553_())));
            this.m_20256_(this.m_20184_().m_82542_((double)f, 0.95, (double)f));
        }
        if (this.m_20069_() && this.f_19797_ % 4 == 0 && Mi28Entity.getSubmergedHeight((Entity)this) > 0.5 * (double)this.m_20206_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.6, 0.6, 0.6));
            this.m_6469_(ModDamageTypes.causeVehicleStrikeDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this, (Entity)(this.m_146895_() == null ? this : this.m_146895_())), 6.0f + (float)(20.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
        }
        Entity passenger = this.m_146895_();
        Entity passenger2 = this.getNthEntity(1);
        Entity passenger3 = this.getNthEntity(2);
        Entity passenger4 = this.getNthEntity(3);
        if (this.getHealth() > 0.1f * this.getMaxHealth()) {
            if (passenger == null) {
                this.leftInputDown = false;
                this.rightInputDown = false;
                this.forwardInputDown = false;
                this.backInputDown = false;
                this.upInputDown = false;
                this.downInputDown = false;
                this.setZRot(this.roll * 0.98f);
                this.m_146926_(this.m_146909_() * 0.98f);
                if (passenger2 == null && passenger3 == null && passenger4 == null) {
                    this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.99f));
                }
            } else if (passenger instanceof Player) {
                Player player = (Player)passenger;
                this.delta_x = (this.m_20096_() ? 0.0f : 0.9f) * ((Float)this.f_19804_.m_135370_(MOUSE_SPEED_Y)).floatValue() * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue();
                this.delta_y = Mth.m_14036_((float)((this.m_20096_() ? 0.06f : 1.2f) * ((Float)this.f_19804_.m_135370_(MOUSE_SPEED_X)).floatValue() * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue() + (float)((Boolean)this.f_19804_.m_135370_(ENGINE2_DAMAGED) != false ? 25 : 0) * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue()), (float)-6.0f, (float)6.0f);
                if (!((Boolean)this.f_19804_.m_135370_(LANDING_INPUT_DOWN)).booleanValue() || this.findNearestLandingPos(30) == null) {
                    if (this.rightInputDown) {
                        ++this.holdTick;
                        this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 1.2f * (float)Math.min((int)this.holdTick, (int)5) * ((Float)this.f_19804_.m_135370_(POWER)).floatValue()));
                    } else if (this.leftInputDown) {
                        ++this.holdTick;
                        this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 1.2f * (float)Math.min((int)this.holdTick, (int)5) * ((Float)this.f_19804_.m_135370_(POWER)).floatValue()));
                    } else {
                        this.holdTick = 0;
                    }
                    this.m_146926_(this.m_146909_() + this.delta_x);
                    this.setZRot(this.getRoll() - ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + (this.m_20096_() ? 0.0f : 0.15f) * ((Float)this.f_19804_.m_135370_(MOUSE_SPEED_X)).floatValue() * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
                }
                this.m_146922_(this.m_146908_() + this.delta_y);
                if (this.findNearestLandingPos(30) != null && !this.m_20096_() && ((Boolean)this.f_19804_.m_135370_(LANDING_INPUT_DOWN)).booleanValue()) {
                    this.updateAutoLanding(this.findNearestLandingPos(30));
                }
                if (this.m_9236_().f_46443_ && this.findNearestLandingPos(30) != null && !this.m_20096_()) {
                    player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.press_s_to_landing"), true);
                }
            }
            if (this.m_9236_() instanceof ServerLevel) {
                if (this.getEnergy() > 0) {
                    boolean up = this.upInputDown || this.forwardInputDown;
                    boolean down = this.downInputDown;
                    if (!this.engineStart && up) {
                        this.engineStart = true;
                        this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.HELICOPTER_ENGINE_START.get(), this.m_5720_(), 3.0f, 1.0f);
                    }
                    if (up && this.engineStartOver) {
                        ++this.holdPowerTick;
                        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + 7.0E-4f * (float)Math.min((int)this.holdPowerTick, (int)10)), (float)0.12f)));
                    }
                    if (this.engineStartOver) {
                        if (down) {
                            ++this.holdPowerTick;
                            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 0.001f * (float)Math.min((int)this.holdPowerTick, (int)5)), (float)(this.m_20096_() ? 0.0f : 0.025f))));
                        } else if (this.backInputDown) {
                            ++this.holdPowerTick;
                            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 0.001f * (float)Math.min((int)this.holdPowerTick, (int)5)), (float)(this.m_20096_() ? 0.0f : 0.059f))));
                        }
                    }
                    if (this.engineStart && !this.engineStartOver) {
                        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + 0.0012f), (float)0.045f)));
                    }
                    if (!up && !down && !this.backInputDown && this.engineStartOver) {
                        if (this.m_20184_().m_7098_() < 0.0) {
                            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + 2.0E-4f), (float)0.12f)));
                        } else {
                            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - (this.m_20096_() ? 5.0E-5f : 2.0E-4f)), (float)0.0f)));
                        }
                        this.holdPowerTick = 0;
                    }
                } else {
                    this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 1.0E-4f), (float)0.0f)));
                    this.forwardInputDown = false;
                    this.backInputDown = false;
                    this.engineStart = false;
                    this.engineStartOver = false;
                }
            }
        } else if (!this.m_20096_() && this.engineStartOver) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 3.0E-4f), (float)0.01f)));
            this.destroyRot += 0.08f;
            float diffX = 45.0f - this.m_146909_();
            float diffZ = -20.0f - this.getRoll();
            this.m_146926_(this.m_146909_() + diffX * 0.05f * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
            this.m_146922_(this.m_146908_() + this.destroyRot);
            this.setZRot(this.getRoll() + diffZ * 0.1f * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(-this.destroyRot) * 0.004, 0.0));
        }
        if (((Boolean)this.f_19804_.m_135370_(ENGINE1_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.98f));
        }
        this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() * 0.9f));
        this.f_19804_.m_135381_(PROPELLER_ROT, (Object)Float.valueOf(Mth.m_14179_((float)0.18f, (float)((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue(), (float)((Float)this.f_19804_.m_135370_(POWER)).floatValue())));
        this.setPropellerRot(this.getPropellerRot() + 30.0f * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
        this.f_19804_.m_135381_(PROPELLER_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue() * 0.9995f));
        if (this.engineStart) {
            this.consumeEnergy((int)((double)((Integer)VehicleConfig.AH_6_MIN_ENERGY_COST.get()).intValue() + (double)((Float)this.f_19804_.m_135370_(POWER)).floatValue() * ((double)((Integer)VehicleConfig.AH_6_MAX_ENERGY_COST.get() - (Integer)VehicleConfig.AH_6_MIN_ENERGY_COST.get()) / 0.12)));
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f force0 = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f force1 = this.transformPosition(transform, 0.0f, 1.0f, 0.0f);
        Vec3 force = new Vec3((double)force0.x, (double)force0.y, (double)force0.z).m_82505_(new Vec3((double)force1.x, (double)force1.y, (double)force1.z));
        this.m_20256_(this.m_20184_().m_82549_(force.m_82490_((double)((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue())));
        if (((Float)this.f_19804_.m_135370_(POWER)).floatValue() > 0.04f) {
            this.engineStartOver = true;
        }
        if (((Float)this.f_19804_.m_135370_(POWER)).floatValue() < 4.0E-4f) {
            this.engineStart = false;
            this.engineStartOver = false;
        }
    }

    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.HELICOPTER_ENGINE.get();
    }

    public float getEngineSoundVolume() {
        return ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue() * 2.0f;
    }

    protected void clampRotation(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float f3 = Mth.m_14036_((float)f2, (float)-80.0f, (float)80.0f);
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
            entity.m_5618_(this.m_146908_());
        } else if (entity == this.getNthEntity(1)) {
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)-80.0f, (float)80.0f);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float f3 = Mth.m_14036_((float)f2, (float)-80.0f, (float)80.0f);
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
            entity.m_5618_(this.m_146908_());
        } else if (entity == this.getNthEntity(2)) {
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float f3 = Mth.m_14036_((float)f2, (float)10.0f, (float)170.0f);
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
            entity.m_5618_(this.m_146908_() + 90.0f);
        } else if (entity == this.getNthEntity(3)) {
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float f3 = Mth.m_14036_((float)f2, (float)-170.0f, (float)-10.0f);
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
            entity.m_5618_(this.m_146908_() - 90.0f);
        }
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        float x = 0.0f;
        float y = 0.38f;
        float z = 0.11f;
        float x_1 = 0.0f;
        float y_2 = -0.25f;
        float z_3 = 1.4f;
        y += (float)passenger.m_6049_();
        int i = this.getOrderedPassengers().indexOf(passenger);
        if (i == 0) {
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        } else if (i == 1) {
            Vector4f worldPosition = this.transformPosition(transform, x_1, y_2, z_3);
            passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        }
        if (passenger != this.m_146895_()) {
            passenger.m_146926_(passenger.m_146909_() + (this.m_146909_() - this.f_19860_));
        }
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.m_5616_(entity.m_6080_() + this.delta_y);
            entity.m_146922_(entity.m_146908_() + this.delta_y);
            entity.m_5618_(this.m_146908_());
        } else if (entity == this.getNthEntity(1)) {
            float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float g = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
            entity.f_19859_ += g - f;
            entity.m_146922_(entity.m_146908_() + g - f + 0.9f * this.destroyRot);
            entity.m_5616_(entity.m_146908_());
            entity.m_5618_(this.m_146908_());
        }
    }

    public Matrix4f getVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.m_14139_((double)ticks, (double)this.f_19854_, (double)this.m_20185_()), (float)Mth.m_14139_((double)ticks, (double)(this.f_19855_ + (double)1.45f), (double)(this.m_20186_() + (double)1.45f)), (float)Mth.m_14139_((double)ticks, (double)this.f_19856_, (double)this.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-Mth.m_14179_((float)ticks, (float)this.f_19859_, (float)this.m_146908_())));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_(Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_())));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Vec3 shootPos(float tickDelta) {
        Matrix4f transform = this.getVehicleTransform(tickDelta);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, -0.83f, 0.8f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public Vec3 shootVec(float tickDelta) {
        Matrix4f transform = this.getVehicleTransform(tickDelta);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 0.01f, 1.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z).m_82505_(new Vec3((double)worldPosition2.x, (double)worldPosition2.y, (double)worldPosition2.z)).m_82541_();
    }

    public void vehicleShoot(LivingEntity living, int type) {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            if (!InventoryTool.hasCreativeAmmoBox((Entity)this.getNthEntity(i))) continue;
            hasCreativeAmmo = true;
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        if (this.getWeaponIndex(0) == 0 && (Integer)this.m_20088_().m_135370_(LOADED_MISSILE) > 0) {
            Vec3 dir;
            LmurEntity LmurEntity2 = ((LmurWeapon)this.getWeapon(0)).create(living);
            Vector4f worldPosition = (Integer)this.m_20088_().m_135370_(LOADED_MISSILE) == 4 ? this.transformPosition(transform, 1.5f, 1.125f, -0.5f) : ((Integer)this.m_20088_().m_135370_(LOADED_MISSILE) == 3 ? this.transformPosition(transform, 1.9375f, 1.125f, -0.5f) : ((Integer)this.m_20088_().m_135370_(LOADED_MISSILE) == 2 ? this.transformPosition(transform, -1.5f, 1.125f, -0.5f) : this.transformPosition(transform, -1.9375f, 1.125f, -0.5f)));
            Vec3 spawnPos = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            Entity target = SeekTool.seekCustomSizeEntity((Entity)this, (Level)this.m_9236_(), (double)384.0, (double)18.0, (double)0.9, (boolean)true);
            if (target != null && target.m_6084_() && target != this) {
                LmurEntity2.setTargetUuid(String.valueOf(target.m_20148_()));
                Vec3 center = target.m_20191_().m_82399_();
                dir = center.m_82546_(spawnPos).m_82541_();
            } else if (!"none".equals(this.getTargetUuid())) {
                LmurEntity2.setTargetUuid(this.getTargetUuid());
                dir = this.shootVec(1.0f).m_82541_();
            } else {
                dir = this.shootVec(1.0f).m_82541_();
            }
            LmurEntity2.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
            LmurEntity2.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, (float)this.m_20184_().m_82553_() + 1.0f, 1.0f);
            living.m_9236_().m_7967_((Entity)LmurEntity2);
            BlockPos pos = BlockPos.m_274446_((Position)spawnPos);
            this.m_9236_().m_5594_(null, pos, (SoundEvent)ModSounds.BOMB_RELEASE.get(), SoundSource.PLAYERS, 3.0f, 1.0f);
            if ((Integer)this.m_20088_().m_135370_(LOADED_MISSILE) == 4) {
                this.reloadCoolDownMissile = 160;
            }
            this.f_19804_.m_135381_(LOADED_MISSILE, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE) - 1));
        } else if (this.getWeaponIndex(0) == 1 && (Integer)this.m_20088_().m_135370_(LOADED_ROCKET) > 0) {
            Vector4f worldPosition2;
            Vector4f worldPosition;
            SmallRocketEntity heliRocketEntity = ((S130Weapon)this.getWeapon(0)).create(living);
            if (this.fireIndex == 0) {
                worldPosition = this.transformPosition(transform, 2.5f, 1.4375f, -0.25f);
                worldPosition2 = this.transformPosition(transform, 2.5065f, 1.4495f, 1.8f);
                this.fireIndex = 1;
            } else {
                worldPosition = this.transformPosition(transform, -2.5f, 1.4375f, -0.25f);
                worldPosition2 = this.transformPosition(transform, -2.4935f, 1.4495f, 1.8f);
                this.fireIndex = 0;
            }
            Vec3 shootVec = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z).m_82505_(new Vec3((double)worldPosition2.x, (double)worldPosition2.y, (double)worldPosition2.z)).m_82541_();
            heliRocketEntity.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            heliRocketEntity.m_6686_(shootVec.f_82479_, shootVec.f_82480_, shootVec.f_82481_, 7.0f, 0.25f);
            living.m_9236_().m_7967_((Entity)heliRocketEntity);
            this.playShootSound3p(living, 0, 6, 6, 6, new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z));
            this.f_19804_.m_135381_(LOADED_ROCKET, (Object)((Integer)this.m_20088_().m_135370_(LOADED_ROCKET) - 1));
            this.reloadCoolDown = 100;
        }
    }

    public int mainGunRpm(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            if (this.getWeaponIndex(0) == 0) {
                return 50;
            }
            if (this.getWeaponIndex(0) == 1) {
                return 150;
            }
        }
        return 0;
    }

    public boolean canShoot(LivingEntity living) {
        if (this.getWeaponIndex(0) == 0) {
            return (Integer)this.f_19804_.m_135370_(AMMO) > 0;
        }
        if (this.getWeaponIndex(0) == 1) {
            return (Integer)this.f_19804_.m_135370_(AMMO) > 0;
        }
        return false;
    }

    public int getAmmoCount(LivingEntity living) {
        return (Integer)this.f_19804_.m_135370_(AMMO);
    }

    public int zoomFov() {
        return 5;
    }

    public int getWeaponHeat(LivingEntity living) {
        return (Integer)this.f_19804_.m_135370_(HEAT);
    }

    public float getRotX(float tickDelta) {
        return this.getPitch(tickDelta);
    }

    public float getRotY(float tickDelta) {
        return this.getYaw(tickDelta);
    }

    public float getRotZ(float tickDelta) {
        return this.getRoll(tickDelta);
    }

    public float getPower() {
        return ((Float)this.f_19804_.m_135370_(POWER)).floatValue();
    }

    public int getDecoy() {
        return (Integer)this.f_19804_.m_135370_(DECOY_COUNT);
    }

    public int getMaxPassengers() {
        return 4;
    }

    public int passengerSeatLocation(Entity entity) {
        return entity == this.getNthEntity(0) ? 2 : 0;
    }

    public ResourceLocation getVehicleIcon() {
        return Mod.loc((String)"textures/vehicle_icon/ah_6_icon.png");
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return seatIndex == 0 ? 0.0 : original;
    }

    public double getMouseSensitivity() {
        return 0.25;
    }

    public double getMouseSpeedX() {
        return 0.4;
    }

    public double getMouseSpeedY() {
        return 0.25;
    }

    @NotNull
    public Vec3 getDismountLocationForIndex(LivingEntity passenger, int index) {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = index == 0 ? this.transformPosition(transform, 2.0f, -0.25f, 1.0f) : (index == 1 ? this.transformPosition(transform, -2.0f, -0.25f, 1.0f) : (index == 2 ? this.transformPosition(transform, -2.0f, -0.25f, 0.0f) : this.transformPosition(transform, 2.0f, -0.25f, 0.0f)));
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Pair<Quaternionf, Quaternionf> getPassengerRotation(Entity entity, float tickDelta) {
        if (this.getSeatIndex(entity) == 2) {
            return Pair.of((Object)Axis.f_252529_.m_252977_(-this.getRoll(tickDelta)), (Object)Axis.f_252403_.m_252977_(this.m_5686_(tickDelta)));
        }
        if (this.getSeatIndex(entity) == 3) {
            return Pair.of((Object)Axis.f_252529_.m_252977_(this.getRoll(tickDelta)), (Object)Axis.f_252403_.m_252977_(-this.m_5686_(tickDelta)));
        }
        return Pair.of((Object)Axis.f_252529_.m_252977_(-this.m_5686_(tickDelta)), (Object)Axis.f_252403_.m_252977_(-this.getRoll(tickDelta)));
    }

    public Matrix4f getClientVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.m_14139_((double)ticks, (double)this.f_19854_, (double)this.m_20185_()), (float)Mth.m_14139_((double)ticks, (double)(this.f_19855_ + (double)1.45f), (double)(this.m_20186_() + (double)1.45f)), (float)Mth.m_14139_((double)ticks, (double)this.f_19856_, (double)this.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_((float)((double)(-Mth.m_14179_((float)ticks, (float)this.f_19859_, (float)this.m_146908_())) + ClientMouseHandler.freeCameraYaw)));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_((float)((double)Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_()) + ClientMouseHandler.freeCameraPitch)));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0) {
            return new Vec2((float)((double)this.getRotY(partialTicks) - ClientMouseHandler.freeCameraYaw), (float)((double)this.getRotX(partialTicks) + ClientMouseHandler.freeCameraPitch));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0) {
            Matrix4f transform = this.getClientVehicleTransform(partialTicks);
            Vector4f maxCameraPosition = this.transformPosition(transform, -2.1f, 1.0f, -10.0f - (float)ClientMouseHandler.custom3pDistanceLerp);
            Vec3 finalPos = CameraTool.getMaxZoom((Matrix4f)transform, (Vector4f)maxCameraPosition);
            if (isFirstPerson) {
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
            return finalPos;
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    public int getHudColor() {
        return super.getHudColor();
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc((String)"textures/gui/vehicle/type/aircraft.png");
    }

    public List<OBB> getOBBs() {
        return List.of(this.obb, this.obb2, this.obb3, this.obb4, this.obb6, this.obb7);
    }

    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0313f, 0.7530999f, -2.9375f);
        this.obb.center().set((Vector3fc)new Vector3f(worldPosition.x, worldPosition.y, worldPosition.z));
        this.obb.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition2 = this.transformPosition(transform, -0.0313f, 0.9719f, 0.8125f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition3 = this.transformPosition(transform, 0.0f, 0.096899986f, -8.1875f);
        this.obb3.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obb3.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition4 = this.transformPosition(transform, 0.0f, 0.6905999f, -11.9375f);
        this.obb4.center().set((Vector3fc)new Vector3f(worldPosition4.x, worldPosition4.y, worldPosition4.z));
        this.obb4.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition6 = this.transformPosition(transform, 1.125f, 1.0188f, -3.0f);
        this.obb6.center().set((Vector3fc)new Vector3f(worldPosition6.x, worldPosition6.y, worldPosition6.z));
        this.obb6.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition7 = this.transformPosition(transform, -1.125f, 1.0188f, -3.0f);
        this.obb7.center().set((Vector3fc)new Vector3f(worldPosition7.x, worldPosition7.y, worldPosition7.z));
        this.obb7.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
    }
}

